/*
 * Decompiled with CFR 0.152.
 */
package jgl;

import java.applet.Applet;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.image.ImageObserver;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import jgl.GL;
import jgl.GLApplet;
import jgl.GLCanvas;
import jgl.GLU;
import jgl.glaux.teapot;
import jgl.glu.GLUquadricObj;
import jgl.glut.glut_menu;

public class GLUT
implements Runnable {
    public static final int GLUT_LEFT_BUTTON = 0;
    public static final int GLUT_MIDDLE_BUTTON = 1;
    public static final int GLUT_RIGHT_BUTTON = 2;
    public static final int GLUT_DOWN = 0;
    public static final int GLUT_UP = 1;
    public static final int GLUT_ACTIVE_SHIFT = 1;
    public static final int GLUT_ACTIVE_CTRL = 2;
    public static final int GLUT_ACTIVE_ALT = 4;
    public static final int GLUT_KEY_F1 = 1;
    public static final int GLUT_KEY_F2 = 2;
    public static final int GLUT_KEY_F3 = 3;
    public static final int GLUT_KEY_F4 = 4;
    public static final int GLUT_KEY_F5 = 5;
    public static final int GLUT_KEY_F6 = 6;
    public static final int GLUT_KEY_F7 = 7;
    public static final int GLUT_KEY_F8 = 8;
    public static final int GLUT_KEY_F9 = 9;
    public static final int GLUT_KEY_F10 = 10;
    public static final int GLUT_KEY_F11 = 11;
    public static final int GLUT_KEY_F12 = 12;
    public static final int GLUT_KEY_LEFT = 100;
    public static final int GLUT_KEY_UP = 101;
    public static final int GLUT_KEY_RIGHT = 102;
    public static final int GLUT_KEY_DOWN = 103;
    public static final int GLUT_KEY_PAGE_UP = 104;
    public static final int GLUT_KEY_PAGE_DOWN = 105;
    public static final int GLUT_KEY_HOME = 106;
    public static final int GLUT_KEY_END = 107;
    public static final int GLUT_KEY_INSERT = 108;
    private GL JavaGL;
    private GLU JavaGLU;
    private int WindowX = 0;
    private int WindowY = 0;
    private int WindowWidth = 300;
    private int WindowHeight = 300;
    private GLUquadricObj quadObj;
    private Method reshapeMethod = null;
    private Method mouseMethod = null;
    private Method motionMethod = null;
    private Method keyMethod = null;
    private Method keyUpMethod = null;
    private Method specialKeyMethod = null;
    private Method specialKeyUpMethod = null;
    private Method displayMethod = null;
    private Method idleMethod = null;
    private Thread JavaThread = null;
    private Component JavaComponent = null;
    private Vector JavaMenus = null;
    private int JavaMenuSize = 0;
    private glut_menu currentMenu = null;
    private int JavaMenuButton = -1;
    private int keyModifiers = 0;

    private void drawBox(float f, int n) {
        float[][] fArrayArray = new float[][]{{-1.0f, 0.0f, 0.0f}, {0.0f, 1.0f, 0.0f}, {1.0f, 0.0f, 0.0f}, {0.0f, -1.0f, 0.0f}, {0.0f, 0.0f, 1.0f}, {0.0f, 0.0f, -1.0f}};
        int[][] nArrayArray = new int[][]{{0, 1, 2, 3}, {3, 2, 6, 7}, {7, 6, 5, 4}, {4, 5, 1, 0}, {5, 6, 2, 1}, {7, 4, 0, 3}};
        float[][] fArray = new float[8][3];
        float f2 = -f / 2.0f;
        fArray[3][0] = f2;
        fArray[2][0] = f2;
        fArray[1][0] = f2;
        fArray[0][0] = f2;
        float f3 = f / 2.0f;
        fArray[7][0] = f3;
        fArray[6][0] = f3;
        fArray[5][0] = f3;
        fArray[4][0] = f3;
        float f4 = -f / 2.0f;
        fArray[5][1] = f4;
        fArray[4][1] = f4;
        fArray[1][1] = f4;
        fArray[0][1] = f4;
        float f5 = f / 2.0f;
        fArray[7][1] = f5;
        fArray[6][1] = f5;
        fArray[3][1] = f5;
        fArray[2][1] = f5;
        float f6 = -f / 2.0f;
        fArray[7][2] = f6;
        fArray[4][2] = f6;
        fArray[3][2] = f6;
        fArray[0][2] = f6;
        float f7 = f / 2.0f;
        fArray[6][2] = f7;
        fArray[5][2] = f7;
        fArray[2][2] = f7;
        fArray[1][2] = f7;
        int n2 = 5;
        while (n2 >= 0) {
            this.JavaGL.glBegin(n);
            this.JavaGL.glNormal3fv(fArrayArray[n2]);
            this.JavaGL.glVertex3fv(fArray[nArrayArray[n2][0]]);
            this.JavaGL.glVertex3fv(fArray[nArrayArray[n2][1]]);
            this.JavaGL.glVertex3fv(fArray[nArrayArray[n2][2]]);
            this.JavaGL.glVertex3fv(fArray[nArrayArray[n2][3]]);
            this.JavaGL.glEnd();
            --n2;
        }
    }

    private void doughnut(float f, float f2, int n, int n2) {
        float f3 = (float)Math.PI * 2 / (float)n2;
        float f4 = (float)Math.PI * 2 / (float)n;
        float f5 = 0.0f;
        float f6 = 1.0f;
        float f7 = 0.0f;
        int n3 = n2 - 1;
        while (n3 >= 0) {
            float f8 = f5 + f3;
            float f9 = (float)Math.cos(f8);
            float f10 = (float)Math.sin(f8);
            this.JavaGL.glBegin(9);
            float f11 = 0.0f;
            int n4 = n;
            while (n4 >= 0) {
                float f12 = (float)Math.cos(f11 += f4);
                float f13 = (float)Math.sin(f11);
                float f14 = f2 + f * f12;
                this.JavaGL.glNormal3f(f9 * f12, -f10 * f12, f13);
                this.JavaGL.glVertex3f(f9 * f14, -f10 * f14, f * f13);
                this.JavaGL.glNormal3f(f6 * f12, -f7 * f12, f13);
                this.JavaGL.glVertex3f(f6 * f14, -f7 * f14, f * f13);
                --n4;
            }
            this.JavaGL.glEnd();
            f5 = f8;
            f6 = f9;
            f7 = f10;
            --n3;
        }
    }

    private void icosahedron(int n) {
        int n2 = 19;
        while (n2 >= 0) {
            --n2;
        }
    }

    public GL auxGetGL() {
        return this.JavaGL;
    }

    public GLU auxGetGLU() {
        return this.JavaGLU;
    }

    public void glutInitWindowPosition(int n, int n2) {
        this.WindowX = n;
        this.WindowY = n2;
    }

    public void glutInitWindowSize(int n, int n2) {
        this.WindowWidth = n;
        this.WindowHeight = n2;
    }

    public void glutMainLoop() {
        block3: {
            if (this.displayMethod == null) break block3;
            try {
                this.displayMethod.invoke((Object)this.JavaComponent, null);
            }
            catch (IllegalAccessException illegalAccessException) {
                System.out.println("IllegalAccessException while DisplayFunc");
            }
            catch (InvocationTargetException invocationTargetException) {
                System.out.println("InvocationTargetException while DisplayFunc");
            }
        }
    }

    public void glutCreateWindow(Component component) {
        component.setSize(this.WindowWidth, this.WindowHeight);
        this.JavaGL.glXMakeCurrent(component, this.WindowX, this.WindowY);
        this.JavaComponent = component;
    }

    public void glutCreateWindow(Applet applet) {
        this.glutCreateWindow((Component)applet);
    }

    public void glutPostRedisplay() {
        try {
            this.displayMethod.invoke((Object)this.JavaComponent, null);
        }
        catch (IllegalAccessException illegalAccessException) {
            System.out.println("IllegalAccessException while DisplayFunc");
        }
        catch (InvocationTargetException invocationTargetException) {
            System.out.println("InvocationTargetException while DisplayFunc");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.JavaComponent.repaint();
    }

    public void glutSwapBuffers(Graphics graphics, ImageObserver imageObserver) {
        this.JavaGL.glXSwapBuffers(graphics, imageObserver);
    }

    public void glutSwapBuffers(Graphics graphics, Applet applet) {
        this.glutSwapBuffers(graphics, (ImageObserver)applet);
    }

    private void QUAD_OBJ_INIT() {
        if (this.quadObj != null) {
            return;
        }
        this.quadObj = this.JavaGLU.gluNewQuadric();
    }

    public void glutWireSphere(double d, int n, int n2) {
        this.QUAD_OBJ_INIT();
        this.JavaGLU.gluQuadricDrawStyle(this.quadObj, 100011);
        this.JavaGLU.gluQuadricNormals(this.quadObj, 100000);
        this.JavaGLU.gluSphere(this.quadObj, d, n, n2);
    }

    public void glutSolidSphere(double d, int n, int n2) {
        this.QUAD_OBJ_INIT();
        this.JavaGLU.gluQuadricDrawStyle(this.quadObj, 100012);
        this.JavaGLU.gluQuadricNormals(this.quadObj, 100000);
        this.JavaGLU.gluSphere(this.quadObj, d, n, n2);
    }

    public void glutWireCone(double d, double d2, int n, int n2) {
        this.QUAD_OBJ_INIT();
        this.JavaGLU.gluQuadricDrawStyle(this.quadObj, 100011);
        this.JavaGLU.gluQuadricNormals(this.quadObj, 100000);
        this.JavaGLU.gluCylinder(this.quadObj, d, 0.0, d2, n, n2);
    }

    public void glutSolidCone(double d, double d2, int n, int n2) {
        this.QUAD_OBJ_INIT();
        this.JavaGLU.gluQuadricDrawStyle(this.quadObj, 100012);
        this.JavaGLU.gluQuadricNormals(this.quadObj, 100000);
        this.JavaGLU.gluCylinder(this.quadObj, d, 0.0, d2, n, n2);
    }

    public void glutWireCube(double d) {
        this.drawBox((float)d, 4);
    }

    public void glutSolidCube(double d) {
        this.drawBox((float)d, 8);
    }

    public void glutWireTorus(double d, double d2, int n, int n2) {
        this.JavaGL.glPushAttrib(8);
        this.JavaGL.glPolygonMode(1032, 6913);
        this.doughnut((float)d, (float)d2, n, n2);
        this.JavaGL.glPopAttrib();
    }

    public void glutSolidTorus(double d, double d2, int n, int n2) {
        this.doughnut((float)d, (float)d2, n, n2);
    }

    public void glutWireIcosahedron() {
        this.icosahedron(4);
    }

    public void glutSolidIcosahedron() {
        this.icosahedron(5);
    }

    public void glutWireTeapot(double d) {
        teapot.Teapot(this.JavaGL, 10, (float)d, 6913);
    }

    public void glutSolidTeapot(double d) {
        teapot.Teapot(this.JavaGL, 14, (float)d, 6914);
    }

    public int glutCreateMenu(String string) {
        if (this.JavaMenus == null) {
            this.JavaMenus = new Vector();
        }
        this.currentMenu = new glut_menu(string, this.JavaMenus.size(), this.JavaComponent);
        this.JavaMenus.addElement(this.currentMenu);
        ++this.JavaMenuSize;
        return this.JavaMenus.size() - 1;
    }

    public void glutDestroyMenu(int n) {
        ((glut_menu)this.JavaMenus.elementAt(n)).glutDestroyMenu();
        if (this.JavaMenuSize-- == 0) {
            this.JavaMenus = null;
        }
    }

    public int glutGetMenu() {
        if (this.currentMenu == null) {
            return -1;
        }
        return this.currentMenu.glutGetMenuID();
    }

    public void glutSetMenu(int n) {
        this.JavaComponent.remove(this.currentMenu.glutGetMenu());
        this.currentMenu = (glut_menu)this.JavaMenus.elementAt(n);
        this.JavaComponent.add(this.currentMenu.glutGetMenu());
    }

    public void glutAddMenuEntry(String string, int n) {
        this.currentMenu.glutAddMenuEntry(string, n);
    }

    public void glutAddSubMenu(String string, int n) {
        glut_menu glut_menu2 = (glut_menu)this.JavaMenus.elementAt(n);
        if (glut_menu2.glutGetMenu().getLabel() == null || glut_menu2.glutGetMenu().getLabel().length() == 0) {
            this.currentMenu.glutAddSubMenu(string, glut_menu2);
        } else {
            glut_menu glut_menu3 = glut_menu2.glutDupMenu();
            glut_menu3.glutSetMenuID(this.JavaMenus.size());
            this.JavaMenus.addElement(glut_menu3);
            ++this.JavaMenuSize;
            this.currentMenu.glutAddSubMenu(string, glut_menu3);
        }
    }

    public void glutChangeToMenuEntry(int n, String string, int n2) {
        this.currentMenu.glutChangeToMenuEntry(n - 1, string, n2);
    }

    public void glutChangeToSubMenu(int n, String string, int n2) {
        glut_menu glut_menu2 = (glut_menu)this.JavaMenus.elementAt(n2);
        if (glut_menu2.glutGetMenu().getLabel() == null || glut_menu2.glutGetMenu().getLabel().length() == 0) {
            this.currentMenu.glutChangeToSubMenu(n - 1, string, glut_menu2);
        } else {
            glut_menu glut_menu3 = glut_menu2.glutDupMenu();
            glut_menu3.glutSetMenuID(this.JavaMenus.size());
            this.JavaMenus.addElement(glut_menu3);
            ++this.JavaMenuSize;
            this.currentMenu.glutChangeToSubMenu(n - 1, string, glut_menu3);
        }
    }

    public void glutRemoveMenuItem(int n) {
        this.currentMenu.glutRemoveMenuItem(n - 1);
    }

    public void glutAttachMenu(int n) {
        this.JavaComponent.add(this.currentMenu.glutGetMenu());
        this.JavaMenuButton = n;
        this.glut_enable_events(16L, true);
    }

    public void glutDetachMenu(int n) {
        if (this.JavaMenuButton == n) {
            if (this.mouseMethod == null) {
                this.glut_enable_events(16L, false);
            }
            this.JavaMenuButton = -1;
        }
        this.JavaComponent.remove(this.currentMenu.glutGetMenu());
    }

    public void processEvent(AWTEvent aWTEvent) {
        if (aWTEvent instanceof MouseEvent) {
            switch (aWTEvent.getID()) {
                case 500: 
                case 501: 
                case 502: 
                case 504: 
                case 505: {
                    this.processMouseEvent((MouseEvent)aWTEvent);
                    break;
                }
                case 503: 
                case 506: {
                    this.processMouseMotionEvent((MouseEvent)aWTEvent);
                }
            }
        } else if (aWTEvent instanceof KeyEvent) {
            this.processKeyEvent((KeyEvent)aWTEvent);
        } else if (aWTEvent instanceof ComponentEvent) {
            this.processComponentEvent((ComponentEvent)aWTEvent);
        }
    }

    public void processComponentEvent(ComponentEvent componentEvent) {
        int n = componentEvent.getID();
        switch (n) {
            case 101: {
                Object[] objectArray = new Object[]{new Integer(this.JavaComponent.getSize().width), new Integer(this.JavaComponent.getSize().height)};
                try {
                    this.reshapeMethod.invoke((Object)this.JavaComponent, objectArray);
                    try {
                        this.displayMethod.invoke((Object)this.JavaComponent, null);
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        System.out.println("IllegalAccessException while DisplayFunc");
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        System.out.println("InvocationTargetException while DisplayFunc");
                    }
                    catch (NullPointerException nullPointerException) {
                    }
                }
                catch (IllegalAccessException illegalAccessException) {
                    System.out.println("IllegalAccessException while ReshapeFunc");
                }
                catch (InvocationTargetException invocationTargetException) {
                    System.out.println("InvocationTargetException while ReshapeFunc");
                }
                catch (NullPointerException nullPointerException) {}
                break;
            }
        }
    }

    private void processKeyModifiers(int n) {
        this.keyModifiers = 0;
        if ((n & 8) != 0) {
            this.keyModifiers |= 4;
        }
        if ((n & 2) != 0) {
            this.keyModifiers |= 2;
        }
        if ((n & 1) != 0) {
            this.keyModifiers |= 1;
        }
    }

    private void invokeKeyMethod(Method method, char c) {
        Object[] objectArray = new Object[]{new Character(c), new Integer(0), new Integer(0)};
        try {
            method.invoke((Object)this.JavaComponent, objectArray);
        }
        catch (IllegalAccessException illegalAccessException) {
            System.out.println("IllegalAccessException while Calling Keyboard Related Functions");
        }
        catch (InvocationTargetException invocationTargetException) {
            System.out.println("InvocationTargetException while Calling Keyboard Related Functions");
        }
        catch (NullPointerException nullPointerException) {}
    }

    private void processKey(Method method, char c) {
        if (c < '\u0080' && c != '\u0000') {
            this.invokeKeyMethod(method, c);
        }
    }

    private void processSpecialKey(Method method, int n) {
        switch (n) {
            case 33: {
                this.invokeKeyMethod(method, 'h');
                break;
            }
            case 34: {
                this.invokeKeyMethod(method, 'i');
                break;
            }
            case 35: {
                this.invokeKeyMethod(method, 'k');
                break;
            }
            case 36: {
                this.invokeKeyMethod(method, 'j');
                break;
            }
            case 37: {
                this.invokeKeyMethod(method, 'd');
                break;
            }
            case 38: {
                this.invokeKeyMethod(method, 'e');
                break;
            }
            case 39: {
                this.invokeKeyMethod(method, 'f');
                break;
            }
            case 40: {
                this.invokeKeyMethod(method, 'g');
                break;
            }
            case 155: {
                this.invokeKeyMethod(method, 'l');
                break;
            }
            default: {
                if (n < 112 || n > 123) break;
                this.invokeKeyMethod(method, (char)(n - 112 + 1));
            }
        }
    }

    public void processKeyEvent(KeyEvent keyEvent) {
        switch (keyEvent.getID()) {
            case 401: {
                this.processKeyModifiers(keyEvent.getModifiers());
                if (this.keyMethod != null) {
                    this.processKey(this.keyMethod, keyEvent.getKeyChar());
                }
                if (this.specialKeyMethod == null) break;
                this.processSpecialKey(this.specialKeyMethod, keyEvent.getKeyCode());
                break;
            }
            case 402: {
                this.processKeyModifiers(keyEvent.getModifiers());
                if (this.keyUpMethod != null) {
                    this.processKey(this.keyUpMethod, keyEvent.getKeyChar());
                }
                if (this.specialKeyUpMethod == null) break;
                this.processSpecialKey(this.specialKeyUpMethod, keyEvent.getKeyCode());
            }
        }
    }

    public void processMouseEvent(MouseEvent mouseEvent) {
        block14: {
            int n = mouseEvent.getID();
            int n2 = -1;
            int n3 = -1;
            if (mouseEvent.isPopupTrigger() && this.JavaMenuButton != -1) {
                this.currentMenu.glutGetMenu().show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                return;
            }
            switch (n) {
                case 501: {
                    n3 = 0;
                    break;
                }
                case 502: {
                    n3 = 1;
                }
            }
            if ((mouseEvent.getModifiers() & 0x10) != 0) {
                n2 = 0;
            } else if ((mouseEvent.getModifiers() & 8) != 0) {
                n2 = 1;
            } else if ((mouseEvent.getModifiers() & 4) != 0) {
                n2 = 2;
            }
            if (n2 == -1 || n3 == -1) break block14;
            Object[] objectArray = new Object[]{new Integer(n2), new Integer(n3), new Integer(mouseEvent.getX()), new Integer(mouseEvent.getY())};
            try {
                this.mouseMethod.invoke((Object)this.JavaComponent, objectArray);
            }
            catch (IllegalAccessException illegalAccessException) {
                System.out.println("IllegalAccessException while MouseFunc");
            }
            catch (InvocationTargetException invocationTargetException) {
                System.out.println("InvocationTargetException while MouseFunc");
            }
            catch (NullPointerException nullPointerException) {}
        }
    }

    public void processMouseMotionEvent(MouseEvent mouseEvent) {
        int n = mouseEvent.getID();
        switch (n) {
            case 503: 
            case 506: {
                Object[] objectArray = new Object[]{new Integer(mouseEvent.getX()), new Integer(mouseEvent.getY())};
                try {
                    this.motionMethod.invoke((Object)this.JavaComponent, objectArray);
                }
                catch (IllegalAccessException illegalAccessException) {
                    System.out.println("IllegalAccessException while MouseMotionFunc");
                }
                catch (InvocationTargetException invocationTargetException) {
                    System.out.println("InvocationTargetException while MouseMotionFunc");
                }
                catch (NullPointerException nullPointerException) {}
                break;
            }
        }
    }

    private void glut_enable_events(long l, boolean bl) {
        if (this.JavaComponent instanceof GLCanvas) {
            ((GLCanvas)this.JavaComponent).glut_enable_events(l, bl);
        } else if (this.JavaComponent instanceof GLApplet) {
            ((GLApplet)this.JavaComponent).glut_enable_events(l, bl);
        }
    }

    public void glutDisplayFunc(String string) {
        if (string != null) {
            try {
                this.displayMethod = this.JavaComponent.getClass().getMethod(string, null);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                System.out.println("No method named " + string);
            }
        } else {
            this.displayMethod = null;
        }
    }

    public void glutReshapeFunc(String string) {
        if (string != null) {
            Class[] classArray = new Class[]{Integer.TYPE, Integer.TYPE};
            Object[] objectArray = new Object[]{new Integer(this.JavaComponent.getSize().width), new Integer(this.JavaComponent.getSize().height)};
            try {
                this.reshapeMethod = this.JavaComponent.getClass().getMethod(string, classArray);
                this.reshapeMethod.invoke((Object)this.JavaComponent, objectArray);
                this.glut_enable_events(1L, true);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                System.out.println("No method named " + string);
            }
            catch (IllegalAccessException illegalAccessException) {
                System.out.println("IllegalAccessException while ReshapeFunc");
            }
            catch (InvocationTargetException invocationTargetException) {
                System.out.println("InvocationTargetException while ReshapeFunc");
            }
        } else {
            this.glut_enable_events(1L, false);
            this.reshapeMethod = null;
        }
    }

    public void glutKeyboardFunc(String string) {
        if (string != null) {
            Class[] classArray = new Class[]{Character.TYPE, Integer.TYPE, Integer.TYPE};
            try {
                this.keyMethod = this.JavaComponent.getClass().getMethod(string, classArray);
                this.glut_enable_events(8L, true);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                System.out.println("No method named " + string);
            }
        } else {
            if (this.keyUpMethod == null && this.specialKeyMethod == null && this.specialKeyUpMethod == null) {
                this.glut_enable_events(8L, false);
            }
            this.keyMethod = null;
        }
    }

    public void glutKeyboardUpFunc(String string) {
        if (string != null) {
            Class[] classArray = new Class[]{Character.TYPE, Integer.TYPE, Integer.TYPE};
            try {
                this.keyUpMethod = this.JavaComponent.getClass().getMethod(string, classArray);
                this.glut_enable_events(8L, true);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                System.out.println("No method named " + string);
            }
        } else {
            if (this.keyMethod == null && this.specialKeyMethod == null && this.specialKeyUpMethod == null) {
                this.glut_enable_events(8L, false);
            }
            this.keyUpMethod = null;
        }
    }

    public void glutSpecialFunc(String string) {
        if (string != null) {
            Class[] classArray = new Class[]{Character.TYPE, Integer.TYPE, Integer.TYPE};
            try {
                this.specialKeyMethod = this.JavaComponent.getClass().getMethod(string, classArray);
                this.glut_enable_events(8L, true);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                System.out.println("No method named " + string);
            }
        } else {
            if (this.keyMethod == null && this.keyUpMethod == null && this.specialKeyUpMethod == null) {
                this.glut_enable_events(8L, false);
            }
            this.specialKeyMethod = null;
        }
    }

    public void glutSpecialUpFunc(String string) {
        if (string != null) {
            Class[] classArray = new Class[]{Character.TYPE, Integer.TYPE, Integer.TYPE};
            try {
                this.specialKeyUpMethod = this.JavaComponent.getClass().getMethod(string, classArray);
                this.glut_enable_events(8L, true);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                System.out.println("No method named " + string);
            }
        } else {
            if (this.keyMethod == null && this.keyUpMethod == null && this.specialKeyMethod == null) {
                this.glut_enable_events(8L, false);
            }
            this.specialKeyUpMethod = null;
        }
    }

    public void glutMouseFunc(String string) {
        if (string != null) {
            Class[] classArray = new Class[]{Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE};
            try {
                this.mouseMethod = this.JavaComponent.getClass().getMethod(string, classArray);
                this.glut_enable_events(16L, true);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                System.out.println("No method named " + string);
            }
        } else {
            if (this.JavaMenuButton == -1) {
                this.glut_enable_events(16L, false);
            }
            this.mouseMethod = null;
        }
    }

    public void glutMotionFunc(String string) {
        if (string != null) {
            Class[] classArray = new Class[]{Integer.TYPE, Integer.TYPE};
            try {
                this.motionMethod = this.JavaComponent.getClass().getMethod(string, classArray);
                this.glut_enable_events(32L, true);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                System.out.println("No method named " + string);
            }
        } else {
            this.glut_enable_events(32L, false);
            this.motionMethod = null;
        }
    }

    public void glutIdleFunc(String string) {
        if (string != null) {
            try {
                this.idleMethod = this.JavaComponent.getClass().getMethod(string, null);
                if (this.JavaThread == null || !this.JavaThread.isAlive()) {
                    this.JavaThread = new Thread(this);
                    this.JavaThread.start();
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                System.out.println("No method named " + string);
            }
        } else {
            this.JavaThread = null;
            this.idleMethod = null;
        }
    }

    public void run() {
        Thread thread = Thread.currentThread();
        while (this.JavaThread == thread) {
            try {
                this.idleMethod.invoke((Object)this.JavaComponent, null);
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException interruptedException) {
                    System.out.println(interruptedException);
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                System.out.println("IllegalAccessException while IdleFunc");
            }
            catch (InvocationTargetException invocationTargetException) {
                System.out.println("InvocationTargetException while IdleFunc");
            }
        }
    }

    public void glutTimerFunc(int n, final String string, int n2) {
        if (string != null) {
            final Class[] classArray = new Class[]{Integer.TYPE};
            final Object[] objectArray = new Object[]{new Integer(n2)};
            Timer timer = new Timer();
            timer.schedule(new TimerTask(){

                public void run() {
                    try {
                        GLUT.this.JavaComponent.getClass().getMethod(string, classArray).invoke((Object)GLUT.this.JavaComponent, objectArray);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        System.out.println("No method named " + string);
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        System.out.println("IllegalAccessException while calling " + string);
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        System.out.println("InvocationTargetException while calling " + string);
                    }
                }
            }, n);
        }
    }

    public int glutGetModifiers() {
        return this.keyModifiers;
    }

    public GLUT() {
        System.out.println("Please call new GLUT (yourGL)");
    }

    public GLUT(GL gL) {
        this.JavaGL = gL;
        this.JavaGLU = new GLU(this.JavaGL);
    }
}

