/*
 * Decompiled with CFR 0.152.
 */
package jgl;

import java.applet.Applet;
import java.awt.Component;
import jgl.GL;
import jgl.GLU;
import jgl.glaux.MODELPTR;
import jgl.glaux.mat_t;
import jgl.glaux.teapot;
import jgl.glu.GLUquadricObj;

public class GLAUX {
    private static final int SPHEREWIRE = 0;
    private static final int CUBEWIRE = 1;
    private static final int BOXWIRE = 2;
    private static final int TORUSWIRE = 3;
    private static final int CYLINDERWIRE = 4;
    private static final int ICOSAWIRE = 5;
    private static final int OCTAWIRE = 6;
    private static final int TETRAWIRE = 7;
    private static final int DODECAWIRE = 8;
    private static final int CONEWIRE = 9;
    private static final int SPHERESOLID = 10;
    private static final int CUBESOLID = 11;
    private static final int BOXSOLID = 12;
    private static final int TORUSSOLID = 13;
    private static final int CYLINDERSOLID = 14;
    private static final int ICOSASOLID = 15;
    private static final int OCTASOLID = 16;
    private static final int TETRASOLID = 17;
    private static final int DODECASOLID = 18;
    private static final int CONESOLID = 19;
    private GL JavaGL;
    private GLU JavaGLU;
    private MODELPTR[] lists = new MODELPTR[25];
    private int WindowX;
    private int WindowY;
    private int WindowWidth;
    private int WindowHeight;
    private static final int STACKDEPTH = 10;
    private static final mat_t[] matstack = new mat_t[10];
    private static final boolean identitymat = true;
    private static final int mattop = 0;

    private void error(String string) {
        System.out.println(string);
        System.exit(1);
    }

    private void diff3(double[] dArray, double[] dArray2, double[] dArray3) {
        dArray3[0] = dArray[0] - dArray2[0];
        dArray3[1] = dArray[1] - dArray2[1];
        dArray3[2] = dArray[2] - dArray2[2];
    }

    private void crossprod(double[] dArray, double[] dArray2, double[] dArray3) {
        double[] dArray4 = new double[]{dArray[1] * dArray2[2] - dArray2[1] * dArray[2], dArray[2] * dArray2[0] - dArray2[2] * dArray[0], dArray[0] * dArray2[1] - dArray2[0] * dArray[1]};
        dArray3[0] = dArray4[0];
        dArray3[1] = dArray4[1];
        dArray3[2] = dArray4[2];
    }

    private void normalize(double[] dArray) {
        double d = Math.sqrt(dArray[0] * dArray[0] + dArray[1] * dArray[1] + dArray[2] * dArray[2]);
        if (d == 0.0) {
            this.error("normalize: zero length vector");
            d = 1.0;
            dArray[0] = 1.0;
        }
        d = 1.0 / d;
        dArray[0] = dArray[0] * d;
        dArray[1] = dArray[1] * d;
        dArray[2] = dArray[2] * d;
    }

    private void m_xformpt(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4) {
        double[] dArray5 = new double[3];
        double[] dArray6 = new double[3];
        mat_t mat_t2 = matstack[0];
        int n = 0;
        while (n < 3) {
            dArray2[n] = dArray[n];
            dArray4[n] = dArray3[n];
            ++n;
        }
    }

    private void m_xformptonly(double[] dArray, double[] dArray2) {
        double[] dArray3 = new double[3];
        mat_t mat_t2 = matstack[0];
        int n = 0;
        while (n < 3) {
            dArray2[n] = dArray[n];
            ++n;
        }
    }

    private void recorditem(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, double d, int n, int n2) {
        double[] dArray5 = new double[3];
        double[] dArray6 = new double[3];
        double[] dArray7 = new double[3];
        double[] dArray8 = new double[3];
        double[] dArray9 = new double[3];
        double[] dArray10 = new double[3];
        double[] dArray11 = new double[3];
        double[] dArray12 = new double[3];
        int n3 = 0;
        while (n3 < 3) {
            dArray5[n3] = dArray[n3] * d + dArray4[n3];
            dArray6[n3] = dArray2[n3] * d + dArray4[n3];
            dArray7[n3] = dArray3[n3] * d + dArray4[n3];
            ++n3;
        }
        if (n2 == 0) {
            this.diff3(dArray5, dArray6, dArray8);
            this.diff3(dArray6, dArray7, dArray9);
            this.crossprod(dArray8, dArray9, dArray9);
            this.normalize(dArray9);
            this.m_xformpt(dArray5, dArray5, dArray9, dArray10);
            this.m_xformptonly(dArray6, dArray6);
            this.m_xformptonly(dArray7, dArray7);
            this.JavaGL.glBegin(n);
            this.JavaGL.glNormal3dv(dArray10);
            this.JavaGL.glVertex3dv(dArray5);
            this.JavaGL.glVertex3dv(dArray6);
            this.JavaGL.glVertex3dv(dArray7);
            this.JavaGL.glEnd();
            return;
        }
        this.m_xformpt(dArray5, dArray5, dArray, dArray10);
        this.m_xformpt(dArray6, dArray6, dArray2, dArray11);
        this.m_xformpt(dArray7, dArray7, dArray3, dArray12);
        this.JavaGL.glBegin(n);
        this.JavaGL.glNormal3dv(dArray10);
        this.JavaGL.glVertex3dv(dArray5);
        this.JavaGL.glNormal3dv(dArray11);
        this.JavaGL.glVertex3dv(dArray6);
        this.JavaGL.glNormal3dv(dArray12);
        this.JavaGL.glVertex3dv(dArray7);
        this.JavaGL.glEnd();
    }

    private void subdivide(int n, double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, double d, int n2, int n3) {
        double d2;
        int n4;
        int n5;
        int n6;
        double[] dArray5 = new double[3];
        double[] dArray6 = new double[3];
        double[] dArray7 = new double[3];
        int n7 = 0;
        while (n7 < n) {
            n6 = 0;
            while (n7 + n6 < n) {
                n5 = n - n7 - n6;
                n4 = 0;
                while (n4 < 3) {
                    dArray5[n4] = ((double)n7 * dArray[n4] + (double)n6 * dArray2[n4] + (double)n5 * dArray3[n4]) / (double)n;
                    dArray6[n4] = ((double)(n7 + 1) * dArray[n4] + (double)n6 * dArray2[n4] + (double)(n5 - 1) * dArray3[n4]) / (double)n;
                    dArray7[n4] = ((double)n7 * dArray[n4] + (double)(n6 + 1) * dArray2[n4] + (double)(n5 - 1) * dArray3[n4]) / (double)n;
                    ++n4;
                }
                d2 = Math.sqrt(dArray5[0] * dArray5[0] + dArray5[1] * dArray5[1] + dArray5[2] * dArray5[2]);
                dArray5[0] = dArray5[0] / d2;
                dArray5[1] = dArray5[1] / d2;
                dArray5[2] = dArray5[2] / d2;
                d2 = Math.sqrt(dArray6[0] * dArray6[0] + dArray6[1] * dArray6[1] + dArray6[2] * dArray6[2]);
                dArray6[0] = dArray6[0] / d2;
                dArray6[1] = dArray6[1] / d2;
                dArray6[2] = dArray6[2] / d2;
                d2 = Math.sqrt(dArray7[0] * dArray7[0] + dArray7[1] * dArray7[1] + dArray7[2] * dArray7[2]);
                dArray7[0] = dArray7[0] / d2;
                dArray7[1] = dArray7[1] / d2;
                dArray7[2] = dArray7[2] / d2;
                this.recorditem(dArray6, dArray5, dArray7, dArray4, d, n2, n3);
                ++n6;
            }
            ++n7;
        }
        n7 = 0;
        while (n7 < n - 1) {
            n6 = 0;
            while (n7 + n6 < n - 1) {
                n5 = n - n7 - n6;
                n4 = 0;
                while (n4 < 3) {
                    dArray5[n4] = ((double)(n7 + 1) * dArray[n4] + (double)(n6 + 1) * dArray2[n4] + (double)(n5 - 2) * dArray3[n4]) / (double)n;
                    dArray6[n4] = ((double)(n7 + 1) * dArray[n4] + (double)n6 * dArray2[n4] + (double)(n5 - 1) * dArray3[n4]) / (double)n;
                    dArray7[n4] = ((double)n7 * dArray[n4] + (double)(n6 + 1) * dArray2[n4] + (double)(n5 - 1) * dArray3[n4]) / (double)n;
                    ++n4;
                }
                d2 = Math.sqrt(dArray5[0] * dArray5[0] + dArray5[1] * dArray5[1] + dArray5[2] * dArray5[2]);
                dArray5[0] = dArray5[0] / d2;
                dArray5[1] = dArray5[1] / d2;
                dArray5[2] = dArray5[2] / d2;
                d2 = Math.sqrt(dArray6[0] * dArray6[0] + dArray6[1] * dArray6[1] + dArray6[2] * dArray6[2]);
                dArray6[0] = dArray6[0] / d2;
                dArray6[1] = dArray6[1] / d2;
                dArray6[2] = dArray6[2] / d2;
                d2 = Math.sqrt(dArray7[0] * dArray7[0] + dArray7[1] * dArray7[1] + dArray7[2] * dArray7[2]);
                dArray7[0] = dArray7[0] / d2;
                dArray7[1] = dArray7[1] / d2;
                dArray7[2] = dArray7[2] / d2;
                this.recorditem(dArray5, dArray6, dArray7, dArray4, d, n2, n3);
                ++n6;
            }
            ++n7;
        }
    }

    private void drawbox(double d, double d2, double d3, double d4, double d5, double d6, int n) {
        double d7;
        double[][] dArrayArray = new double[][]{{-1.0, 0.0, 0.0}, {0.0, 1.0, 0.0}, {1.0, 0.0, 0.0}, {0.0, -1.0, 0.0}, {0.0, 0.0, 1.0}, {0.0, 0.0, -1.0}};
        int[][] nArrayArray = new int[][]{{0, 1, 2, 3}, {3, 2, 6, 7}, {7, 6, 5, 4}, {4, 5, 1, 0}, {5, 6, 2, 1}, {7, 4, 0, 3}};
        double[][] dArray = new double[8][3];
        if (d > d2) {
            d7 = d;
            d = d2;
            d2 = d7;
        }
        if (d3 > d4) {
            d7 = d3;
            d3 = d4;
            d4 = d7;
        }
        if (d5 > d6) {
            d7 = d5;
            d5 = d6;
            d6 = d7;
        }
        double d8 = d;
        dArray[3][0] = d8;
        dArray[2][0] = d8;
        dArray[1][0] = d8;
        dArray[0][0] = d8;
        double d9 = d2;
        dArray[7][0] = d9;
        dArray[6][0] = d9;
        dArray[5][0] = d9;
        dArray[4][0] = d9;
        double d10 = d3;
        dArray[5][1] = d10;
        dArray[4][1] = d10;
        dArray[1][1] = d10;
        dArray[0][1] = d10;
        double d11 = d4;
        dArray[7][1] = d11;
        dArray[6][1] = d11;
        dArray[3][1] = d11;
        dArray[2][1] = d11;
        double d12 = d5;
        dArray[7][2] = d12;
        dArray[4][2] = d12;
        dArray[3][2] = d12;
        dArray[0][2] = d12;
        double d13 = d6;
        dArray[6][2] = d13;
        dArray[5][2] = d13;
        dArray[2][2] = d13;
        dArray[1][2] = d13;
        int n2 = 0;
        while (n2 < 6) {
            this.JavaGL.glBegin(n);
            this.JavaGL.glNormal3dv(dArrayArray[n2]);
            this.JavaGL.glVertex3dv(dArray[nArrayArray[n2][0]]);
            this.JavaGL.glNormal3dv(dArrayArray[n2]);
            this.JavaGL.glVertex3dv(dArray[nArrayArray[n2][1]]);
            this.JavaGL.glNormal3dv(dArrayArray[n2]);
            this.JavaGL.glVertex3dv(dArray[nArrayArray[n2][2]]);
            this.JavaGL.glNormal3dv(dArrayArray[n2]);
            this.JavaGL.glVertex3dv(dArray[nArrayArray[n2][3]]);
            this.JavaGL.glEnd();
            ++n2;
        }
    }

    private void doughnut(double d, double d2, int n, int n2, int n3) {
        double[] dArray = new double[3];
        double[] dArray2 = new double[3];
        double[] dArray3 = new double[3];
        double[] dArray4 = new double[3];
        double[] dArray5 = new double[3];
        double[] dArray6 = new double[3];
        double[] dArray7 = new double[3];
        double[] dArray8 = new double[3];
        int n4 = 0;
        while (n4 < n2) {
            double d3 = (double)n4 * 2.0 * Math.PI / (double)n2;
            double d4 = (double)(n4 + 1) * 2.0 * Math.PI / (double)n2;
            int n5 = 0;
            while (n5 < n) {
                double d5 = (double)n5 * 2.0 * Math.PI / (double)n;
                double d6 = (double)(n5 + 1) * 2.0 * Math.PI / (double)n;
                dArray[0] = Math.cos(d3) * (d2 + d * Math.cos(d5));
                dArray[1] = -Math.sin(d3) * (d2 + d * Math.cos(d5));
                dArray[2] = d * Math.sin(d5);
                dArray2[0] = Math.cos(d4) * (d2 + d * Math.cos(d5));
                dArray2[1] = -Math.sin(d4) * (d2 + d * Math.cos(d5));
                dArray2[2] = d * Math.sin(d5);
                dArray3[0] = Math.cos(d4) * (d2 + d * Math.cos(d6));
                dArray3[1] = -Math.sin(d4) * (d2 + d * Math.cos(d6));
                dArray3[2] = d * Math.sin(d6);
                dArray4[0] = Math.cos(d3) * (d2 + d * Math.cos(d6));
                dArray4[1] = -Math.sin(d3) * (d2 + d * Math.cos(d6));
                dArray4[2] = d * Math.sin(d6);
                dArray5[0] = Math.cos(d3) * Math.cos(d5);
                dArray5[1] = -Math.sin(d3) * Math.cos(d5);
                dArray5[2] = Math.sin(d5);
                dArray6[0] = Math.cos(d4) * Math.cos(d5);
                dArray6[1] = -Math.sin(d4) * Math.cos(d5);
                dArray6[2] = Math.sin(d5);
                dArray7[0] = Math.cos(d4) * Math.cos(d6);
                dArray7[1] = -Math.sin(d4) * Math.cos(d6);
                dArray7[2] = Math.sin(d6);
                dArray8[0] = Math.cos(d3) * Math.cos(d6);
                dArray8[1] = -Math.sin(d3) * Math.cos(d6);
                dArray8[2] = Math.sin(d6);
                this.m_xformpt(dArray, dArray, dArray5, dArray5);
                this.m_xformpt(dArray2, dArray2, dArray6, dArray6);
                this.m_xformpt(dArray3, dArray3, dArray7, dArray7);
                this.m_xformpt(dArray4, dArray4, dArray8, dArray8);
                this.JavaGL.glBegin(n3);
                this.JavaGL.glNormal3dv(dArray8);
                this.JavaGL.glVertex3dv(dArray4);
                this.JavaGL.glNormal3dv(dArray7);
                this.JavaGL.glVertex3dv(dArray3);
                this.JavaGL.glNormal3dv(dArray6);
                this.JavaGL.glVertex3dv(dArray2);
                this.JavaGL.glNormal3dv(dArray5);
                this.JavaGL.glVertex3dv(dArray);
                this.JavaGL.glEnd();
                ++n5;
            }
            ++n4;
        }
    }

    private void icosahedron(double[] dArray, double d, int n) {
        int n2 = 0;
        while (n2 < 20) {
            ++n2;
        }
    }

    private int findList(int n, double[] dArray, int n2) {
        MODELPTR mODELPTR = this.lists[n];
        while (mODELPTR != null) {
            if (this.compareParams(mODELPTR.params, dArray, n2)) {
                return mODELPTR.list;
            }
            mODELPTR = mODELPTR.ptr;
        }
        return 0;
    }

    private boolean compareParams(double[] dArray, double[] dArray2, int n) {
        boolean bl = true;
        int n2 = 0;
        while (n2 < n && bl) {
            if (dArray[n2] != dArray2[n2]) {
                bl = false;
            }
            ++n2;
        }
        return bl;
    }

    private int makeModelPtr(int n, double[] dArray, int n2) {
        MODELPTR mODELPTR = new MODELPTR();
        mODELPTR.list = this.JavaGL.glGenLists(1);
        mODELPTR.numParam = n2;
        mODELPTR.params = dArray;
        mODELPTR.ptr = this.lists[n];
        this.lists[n] = mODELPTR;
        return mODELPTR.list;
    }

    public GL auxGetGL() {
        return this.JavaGL;
    }

    public GLU auxGetGLU() {
        return this.JavaGLU;
    }

    public void auxInitPosition(int n, int n2, int n3, int n4) {
        this.WindowX = n;
        this.WindowY = n2;
        this.WindowWidth = n3;
        this.WindowHeight = n4;
    }

    public void auxInitWindow(Component component) {
        component.setSize(this.WindowWidth, this.WindowHeight);
        this.JavaGL.glXMakeCurrent(component, this.WindowX, this.WindowY);
    }

    public void auxInitWindow(Applet applet) {
        this.auxInitWindow((Component)applet);
    }

    public void auxWireSphere(double d) {
        double[] dArray = new double[]{d};
        int n = this.findList(0, dArray, 1);
        if (n == 0) {
            this.JavaGL.glNewList(this.makeModelPtr(0, dArray, 1), 4865);
            GLUquadricObj gLUquadricObj = this.JavaGLU.gluNewQuadric();
            this.JavaGLU.gluQuadricDrawStyle(gLUquadricObj, 100011);
            this.JavaGLU.gluSphere(gLUquadricObj, d, 16, 16);
            this.JavaGL.glEndList();
        } else {
            this.JavaGL.glCallList(n);
        }
    }

    public void auxSolidSphere(double d) {
        double[] dArray = new double[]{d};
        int n = this.findList(10, dArray, 1);
        if (n == 0) {
            this.JavaGL.glNewList(this.makeModelPtr(10, dArray, 1), 4865);
            GLUquadricObj gLUquadricObj = this.JavaGLU.gluNewQuadric();
            this.JavaGLU.gluQuadricDrawStyle(gLUquadricObj, 100012);
            this.JavaGLU.gluQuadricNormals(gLUquadricObj, 100000);
            this.JavaGLU.gluSphere(gLUquadricObj, d, 16, 16);
            this.JavaGL.glEndList();
        } else {
            this.JavaGL.glCallList(n);
        }
    }

    public void auxWireCube(double d) {
        double[] dArray = new double[]{d};
        int n = this.findList(1, dArray, 1);
        if (n == 0) {
            this.JavaGL.glNewList(this.makeModelPtr(1, dArray, 1), 4865);
            this.drawbox(-d / 2.0, d / 2.0, -d / 2.0, d / 2.0, -d / 2.0, d / 2.0, 4);
            this.JavaGL.glEndList();
        } else {
            this.JavaGL.glCallList(n);
        }
    }

    public void auxSolidCube(double d) {
        double[] dArray = new double[]{d};
        int n = this.findList(11, dArray, 1);
        if (n == 0) {
            this.JavaGL.glNewList(this.makeModelPtr(11, dArray, 1), 4865);
            this.drawbox(-d / 2.0, d / 2.0, -d / 2.0, d / 2.0, -d / 2.0, d / 2.0, 8);
            this.JavaGL.glEndList();
        } else {
            this.JavaGL.glCallList(n);
        }
    }

    public void auxWireBox(double d, double d2, double d3) {
        double[] dArray = new double[]{d, d2, d3};
        int n = this.findList(2, dArray, 3);
        if (n == 0) {
            this.JavaGL.glNewList(this.makeModelPtr(2, dArray, 3), 4865);
            this.drawbox(-d / 2.0, d / 2.0, -d2 / 2.0, d2 / 2.0, -d3 / 2.0, d3 / 2.0, 4);
            this.JavaGL.glEndList();
        } else {
            this.JavaGL.glCallList(n);
        }
    }

    public void auxSolidBox(double d, double d2, double d3) {
        double[] dArray = new double[]{d, d2, d3};
        int n = this.findList(12, dArray, 3);
        if (n == 0) {
            this.JavaGL.glNewList(this.makeModelPtr(12, dArray, 3), 4865);
            this.drawbox(-d / 2.0, d / 2.0, -d2 / 2.0, d2 / 2.0, -d3 / 2.0, d3 / 2.0, 8);
            this.JavaGL.glEndList();
        } else {
            this.JavaGL.glCallList(n);
        }
    }

    public void auxWireTorus(double d, double d2) {
        double[] dArray = new double[]{d, d2};
        int n = this.findList(3, dArray, 2);
        if (n == 0) {
            this.JavaGL.glNewList(this.makeModelPtr(3, dArray, 2), 4865);
            this.doughnut(d, d2, 5, 10, 4);
            this.JavaGL.glEndList();
        } else {
            this.JavaGL.glCallList(n);
        }
    }

    public void auxSolidTorus(double d, double d2) {
        double[] dArray = new double[]{d, d2};
        int n = this.findList(13, dArray, 2);
        if (n == 0) {
            this.JavaGL.glNewList(this.makeModelPtr(13, dArray, 2), 4865);
            this.doughnut(d, d2, 8, 15, 8);
            this.JavaGL.glEndList();
        } else {
            this.JavaGL.glCallList(n);
        }
    }

    public void auxWireCylinder(double d, double d2) {
        double[] dArray = new double[]{d, d2};
        int n = this.findList(4, dArray, 2);
        if (n == 0) {
            this.JavaGL.glNewList(this.makeModelPtr(4, dArray, 2), 4865);
            this.JavaGL.glPushMatrix();
            this.JavaGL.glRotatef(90.0f, 1.0f, 0.0f, 0.0f);
            this.JavaGL.glTranslatef(0.0f, 0.0f, -1.0f);
            GLUquadricObj gLUquadricObj = this.JavaGLU.gluNewQuadric();
            this.JavaGLU.gluQuadricDrawStyle(gLUquadricObj, 100011);
            this.JavaGLU.gluCylinder(gLUquadricObj, d, d, d2, 12, 2);
            this.JavaGL.glPopMatrix();
            this.JavaGL.glEndList();
        } else {
            this.JavaGL.glCallList(n);
        }
    }

    public void auxSolidCylinder(double d, double d2) {
        double[] dArray = new double[]{d, d2};
        int n = this.findList(14, dArray, 2);
        if (n == 0) {
            this.JavaGL.glNewList(this.makeModelPtr(14, dArray, 2), 4865);
            this.JavaGL.glPushMatrix();
            this.JavaGL.glRotatef(90.0f, 1.0f, 0.0f, 0.0f);
            this.JavaGL.glTranslatef(0.0f, 0.0f, -1.0f);
            GLUquadricObj gLUquadricObj = this.JavaGLU.gluNewQuadric();
            this.JavaGLU.gluQuadricDrawStyle(gLUquadricObj, 100012);
            this.JavaGLU.gluQuadricNormals(gLUquadricObj, 100000);
            this.JavaGLU.gluCylinder(gLUquadricObj, d, d, d2, 12, 2);
            this.JavaGL.glPopMatrix();
            this.JavaGL.glEndList();
        } else {
            this.JavaGL.glCallList(n);
        }
    }

    public void auxWireIcosahedron(double d) {
        double[] dArray = new double[]{d};
        int n = this.findList(5, dArray, 1);
        double[] dArray2 = new double[]{0.0, 0.0, 0.0};
        if (n == 0) {
            this.JavaGL.glNewList(this.makeModelPtr(5, dArray, 1), 4865);
            this.icosahedron(dArray2, d, 4);
            this.JavaGL.glEndList();
        } else {
            this.JavaGL.glCallList(n);
        }
    }

    public void auxSolidIcosahedron(double d) {
        double[] dArray = new double[]{d};
        int n = this.findList(15, dArray, 1);
        double[] dArray2 = new double[]{0.0, 0.0, 0.0};
        if (n == 0) {
            this.JavaGL.glNewList(this.makeModelPtr(15, dArray, 1), 4865);
            this.icosahedron(dArray2, d, 5);
            this.JavaGL.glEndList();
        } else {
            this.JavaGL.glCallList(n);
        }
    }

    public void auxWireCone(double d, double d2) {
        double[] dArray = new double[]{d, d2};
        int n = this.findList(9, dArray, 2);
        if (n == 0) {
            this.JavaGL.glNewList(this.makeModelPtr(9, dArray, 2), 4865);
            GLUquadricObj gLUquadricObj = this.JavaGLU.gluNewQuadric();
            this.JavaGLU.gluQuadricDrawStyle(gLUquadricObj, 100011);
            this.JavaGLU.gluCylinder(gLUquadricObj, d, 0.0, d2, 15, 10);
            this.JavaGL.glEndList();
        } else {
            this.JavaGL.glCallList(n);
        }
    }

    public void auxSolidCone(double d, double d2) {
        double[] dArray = new double[]{d, d2};
        int n = this.findList(19, dArray, 2);
        if (n == 0) {
            this.JavaGL.glNewList(this.makeModelPtr(19, dArray, 2), 4865);
            GLUquadricObj gLUquadricObj = this.JavaGLU.gluNewQuadric();
            this.JavaGLU.gluQuadricDrawStyle(gLUquadricObj, 100012);
            this.JavaGLU.gluQuadricNormals(gLUquadricObj, 100000);
            this.JavaGLU.gluCylinder(gLUquadricObj, d, 0.0, d2, 15, 10);
            this.JavaGL.glEndList();
        } else {
            this.JavaGL.glCallList(n);
        }
    }

    public void auxWireTeapot(double d) {
        teapot.aux_wire_teapot(this.JavaGL, d);
    }

    public void auxSolidTeapot(double d) {
        teapot.aux_solid_teapot(this.JavaGL, d);
    }

    public GLAUX() {
        System.out.println("Please call new GLAUX (yourGL)");
    }

    public GLAUX(GL gL) {
        this.JavaGL = gL;
        this.JavaGLU = new GLU(this.JavaGL);
    }

    static {
        GLAUX.matstack[0] = new mat_t(1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0);
    }
}

