/*
 * Decompiled with CFR 0.152.
 */
package frams_client_3d;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;

public class Log
extends JFrame {
    private JPanel jContentPane = null;
    private JScrollPane jScrollPane = null;
    private JTextPane jTextPane = null;
    private StyledDocument doc = null;
    private SimpleAttributeSet defaultAttributeSet = null;
    public static int RED = 0;
    public static int ORANGE = 1;
    public static int GREEN = 2;
    public static int BLUE = 3;
    public static int BLACK = 4;

    public Log() {
        this.initialize();
        this.setDefaultCloseOperation(1);
    }

    private void initialize() {
        this.setSize(450, 300);
        this.setContentPane(this.getJContentPane());
        this.setTitle("Frams Client 3D - network log");
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.add((Component)this.getJScrollPane(), "Center");
        }
        return this.jContentPane;
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setViewportView(this.getJTextPane());
            this.jScrollPane.setWheelScrollingEnabled(true);
        }
        return this.jScrollPane;
    }

    private JTextPane getJTextPane() {
        if (this.jTextPane == null) {
            this.jTextPane = new JTextPane();
            this.jTextPane.setMargin(new Insets(0, 5, 0, 5));
            this.jTextPane.setEditable(false);
            this.doc = this.jTextPane.getStyledDocument();
            this.defaultAttributeSet = new SimpleAttributeSet();
            StyleConstants.setFontFamily(this.defaultAttributeSet, "Monospaced");
            StyleConstants.setFontSize(this.defaultAttributeSet, 11);
        }
        return this.jTextPane;
    }

    public void addLogLine(String line, Color color) {
        SimpleAttributeSet set = new SimpleAttributeSet(this.defaultAttributeSet);
        StyleConstants.setForeground(set, color);
        try {
            this.doc.insertString(this.doc.getLength(), String.valueOf(line) + "\n", set);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }
}

